#include <string>
#include <list>
#include <cstdio>
#include "maxent.h"

using namespace std;

void train_the_model_with_samples(ME_Model & model)
{
  ME_Sample s1;
  s1.label = "CAR";
  s1.features.push_back("four wheels");
  s1.features.push_back("blue");

  ME_Sample s2;
  s2.label = "CAR";
  s2.features.push_back("four wheels");
  s2.features.push_back("red");

  ME_Sample s3;
  s3.label = "BICYCLE";
  s3.features.push_back("two wheels");
  s3.features.push_back("red");

  ME_Sample s4;
  s4.label = "BICYCLE";
  s4.features.push_back("two wheels");
  s4.features.push_back("yellow");

  model.add_training_sample(s1);
  model.add_training_sample(s2);
  model.add_training_sample(s3);
  model.add_training_sample(s4);

  model.train();
}

int main()
{
  ME_Model model;

  train_the_model_with_samples(model);
  
  // classifying a new sample
  ME_Sample s;
  s.features.push_back("two wheels");
  s.features.push_back("blue");

  model.classify(s);
  cout << endl;
  cout << "it's a " << s.label << " !" << endl << endl;

  // optionally, you can get the probability distribution of a classification
  vector<double> vp = model.classify(s);
  for (int i = 0; i < model.num_classes(); i++) {
    cout << vp[i] << "\t" <<  model.get_class_label(i) << endl;
  }
  cout << endl;
  
  // if you want to get the weights of the features
  list< pair< pair<string, string>, double > > fl;
  model.get_features(fl);
  for (list< pair< pair<string, string>, double> >::const_iterator i = fl.begin(); i != fl.end(); i++) {
    printf("%10.3f  %-10s %s\n", i->second, i->first.first.c_str(), i->first.second.c_str());
  }
  
  // you can save the model to a file
  model.save_to_file("model");
  // of course, you can load a model from a file.
  // try model.load_from_file("model") instead of train_the_model_with_samples().
}
